<?php
if (!defined('ABSPATH')) exit;

class Audit_Display {
    public static function render_main_page() {
        if (!is_user_logged_in()) {
            wp_die(__('You must be logged in to view this page.'));
        }

        echo '<div class="wrap">';
        
        // echo '<h1>Audit Trail Logs</h1>';

        // Render the tabbed layout with actions and JS
        Audit_Logger::render_tabs_html();

        echo '</div>';
    }

    public static function render_login_history_table($user_id) {
        global $wpdb;
        $table_name = $wpdb->prefix . 'audit_trail_login_history';

        $limit = min(max(intval($_GET['limit'] ?? 15), 15), 30);
        $paged = max(1, intval($_GET['paged'] ?? 1));
        $offset = ($paged - 1) * $limit;

        $current_user = wp_get_current_user();
        $username = $current_user->user_login;

    $total = $wpdb->get_var(
    $wpdb->prepare(
        "SELECT COUNT(*) FROM $table_name WHERE user_id = %d OR (user_id = 0 AND username = %s)",
        $user_id,
        $username
    )
);

    $rows = $wpdb->get_results(
    $wpdb->prepare(
        "SELECT * FROM $table_name WHERE user_id = %d OR (user_id = 0 AND username = %s) ORDER BY login_time DESC LIMIT %d OFFSET %d",
        $user_id,
        $username,
        $limit,
        $offset
    )
);

        echo '<h2>Login History</h2>';
        echo '<table class="widefat striped audit-table"><thead><tr>';
        echo '<th>Sr No</th><th>User ID</th><th>User Name</th><th>IP Address</th><th>Browser</th><th>Login Time</th><th>Logout Time</th><th>Status</th><th>Message</th>';
        echo '</tr></thead><tbody>';

        $sr = $offset + 1;
        foreach ($rows as $row) {
    $status_icon = '';
    $status_class = '';
    $status_label = esc_html($row->status);

    switch (strtolower($row->status)) {
        case 'login':
            $status_icon = '<i class="fas fa-sign-in-alt"></i>';
            $status_class = 'status-login';
            break;
        case 'failed login':
            $status_icon = '<i class="fas fa-times-circle"></i>';
            $status_class = 'status-failed';
            break;
        case 'logout':
            $status_icon = '<i class="fas fa-sign-out-alt"></i>';
            $status_class = 'status-logout';
            break;
    }

    echo "<tr>
        <td>{$sr}</td>
        <td>" . ($row->user_id ?: '-') . "</td>
        <td>{$row->username}</td>
        <td>{$row->ip_address}</td>
        <td>" . esc_html(wp_trim_words($row->browser, 10)) . "</td>
        <td>" . esc_html(date_i18n('Y-m-d g:i a', strtotime($row->login_time))) . "</td>
        <td>" . esc_html($row->logout_time ? date_i18n('Y-m-d g:i a', strtotime($row->logout_time)) : '-') . "</td>
        <td class='{$status_class}'>{$status_icon} {$status_label}</td>
        <td>{$row->message}</td>
    </tr>";
    $sr++;
}


        echo '</tbody></table>';
        self::render_pagination($paged, $limit, $total, 'limit', 'paged');
    }

    public static function render_activity_log_table($user_id) {
        global $wpdb;
        $table_name = $wpdb->prefix . 'audit_trail_user_activities';

        $limit = min(max(intval($_GET['limit_act'] ?? 15), 15), 30);
        $paged = max(1, intval($_GET['paged_act'] ?? 1));
        $offset = ($paged - 1) * $limit;

        $total = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE user_id = %d", $user_id));
        $rows = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE user_id = %d ORDER BY datetime DESC LIMIT %d OFFSET %d", $user_id, $limit, $offset));

        echo '<h2>User Activity Logs</h2>';
        echo '<table class="widefat striped audit-table"><thead><tr>';
        echo '<th>Sr No</th><th>ID</th><th>User ID</th><th>User Role</th><th>Date & Time</th><th>Activity</th><th>Type</th><th>Description</th>';
        echo '</tr></thead><tbody>';
            
        $sr = $offset + 1;
        foreach ($rows as $row) {
    $icon = '';
    switch ($row->type) {
        case 'post':
            $icon = '<i class="fas fa-pencil-alt"></i>';
            break;
        case 'plugin':
            $icon = '<i class="fas fa-plug"></i>';
            break;
        case 'theme':
            $icon = '<i class="fas fa-paint-brush"></i>';
            break;
        case 'user':
            $icon = '<i class="fas fa-user"></i>';
            break;
        default:
            $icon = '<i class="fas fa-info-circle"></i>';
    }

    echo "<tr>
        <td>{$sr}</td>
        <td>{$row->id}</td>
        <td>{$row->user_id}</td>
        <td>{$row->role}</td>
        <td>" . esc_html(date_i18n('Y-m-d g:i a', strtotime($row->datetime))) . "</td>
        <td>{$icon} {$row->activity}</td>
        <td>{$row->type}</td>
        <td>{$row->description}</td>
    </tr>";
    $sr++;
}


        echo '</tbody></table>';
        self::render_pagination($paged, $limit, $total, 'limit_act', 'paged_act');
    }

    private static function render_pagination($paged, $limit, $total, $limit_key, $paged_key) {
        $total_pages = ceil($total / $limit);
        if ($total_pages <= 1) return;

        echo '<div class="tablenav"><div class="tablenav-pages audit-pagination">';
        for ($i = 1; $i <= $total_pages; $i++) {
            $url = add_query_arg([$paged_key => $i, $limit_key => $limit]);
            $current = $i === $paged ? ' class="page-numbers current"' : ' class="page-numbers"';
            echo "<a href='" . esc_url($url) . "'{$current}>$i</a> ";
        }
        echo '</div></div>';
    }
}

// Hook rendering for tab content
add_action('audit_trail_render_login_history_table', function () {
    $current_user = wp_get_current_user();
    Audit_Display::render_login_history_table($current_user->ID);
});

add_action('audit_trail_render_user_activity_table', function () {
    $current_user = wp_get_current_user();
    Audit_Display::render_activity_log_table($current_user->ID);
});
